/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.path;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementDefault;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;

public abstract class PathElementCable
extends PathElementDefault {
    protected abstract ICable getCable();

    @Override
    public Set<ISidedPathElement> getReachableElements() {
        HashSet elements = Sets.newHashSet();
        BlockPos pos = this.getPosition().getBlockPos();
        for (Direction side : Direction.values()) {
            if (!this.getCable().isConnected(side)) continue;
            BlockPos posOffset = pos.m_142300_(side);
            Direction pathElementSide = side.m_122424_();
            IPathElement pathElement = (IPathElement)BlockEntityHelpers.getCapability((BlockGetter)this.getPosition().getLevel(true), (BlockPos)posOffset, (Direction)pathElementSide, PathElementConfig.CAPABILITY).orElse(null);
            if (pathElement == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The position at %s was incorrectly marked as reachable as path element by %s at %s side %s.", posOffset, this.getCable(), pos, side));
                continue;
            }
            elements.add(SidedPathElement.of(pathElement, pathElementSide));
        }
        return elements;
    }
}

